<div class="row">
	<div class="col-md-12">
		<h4>@lang('product.variations'):</h4>
	</div>
	<div class="col-md-12">
		<div class="table-responsive">
			<table class="table bg-gray">
				<tr class="bg-green">
					<th>@lang('product.variations')</th>
					<th>@lang('product.sku')</th>
					<th>@lang('product.default_purchase_price') (@lang('product.exc_of_tax'))</th>
					<th>@lang('product.default_purchase_price') (@lang('product.inc_of_tax'))</th>
					@can('access_default_selling_price')
				        <th>@lang('product.profit_percent')</th>
				        <th>@lang('product.default_selling_price') (@lang('product.exc_of_tax'))</th>
				        <th>@lang('product.default_selling_price') (@lang('product.inc_of_tax'))</th>
			        @endcan
			        @if(!empty($allowed_group_prices))
			        	<th>@lang('lang_v1.group_prices')</th>
			        @endif
				</tr>
				@foreach($product->variations as $variation)
				<tr>
					<td>
						{{$variation->product_variation->name}} - {{ $variation->name }}
					</td>
					<td>
						{{ $variation->sub_sku }}
					</td>
					<td>
						<span class="display_currency" data-currency_symbol="true">{{ $variation->default_purchase_price }}</span>
					</td>
					<td>
						<span class="display_currency" data-currency_symbol="true">{{ $variation->dpp_inc_tax }}</span>
					</td>
					@can('access_default_selling_price')
						<td>
							{{ $variation->profit_percent }}
						</td>
						<td>
							<span class="display_currency" data-currency_symbol="true">{{ $variation->default_sell_price }}</span>
						</td>
						<td>
							<span class="display_currency" data-currency_symbol="true">{{ $variation->sell_price_inc_tax }}</span>
						</td>
					@endcan
					@if(!empty($allowed_group_prices))
			        	<td class="td-full-width">
			        		@foreach($allowed_group_prices as $key => $value)
			        			<strong>{{$value}}</strong> - @if(!empty($group_price_details[$variation->id][$key]))
			        				<span class="display_currency" data-currency_symbol="true">{{ $group_price_details[$variation->id][$key] }}</span>
			        			@else
			        				0
			        			@endif
			        			<br>
			        		@endforeach
			        	</td>
			        @endif
				</tr>
				@endforeach
			</table>
		</div>
	</div>
</div>